package gov.va.caret.model.impl;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.CacheModel;

import gov.va.caret.model.PMReadMessage;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

import java.util.Date;

/**
 * The cache model class for representing PMReadMessage in entity cache.
 *
 * @author caret
 * @see PMReadMessage
 * @generated
 */
public class PMReadMessageCacheModel implements CacheModel<PMReadMessage>,
    Externalizable {
    public long readMessageId;
    public long messageId;
    public long readDate;

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(7);

        sb.append("{readMessageId=");
        sb.append(readMessageId);
        sb.append(", messageId=");
        sb.append(messageId);
        sb.append(", readDate=");
        sb.append(readDate);
        sb.append("}");

        return sb.toString();
    }

    @Override
    public PMReadMessage toEntityModel() {
        PMReadMessageImpl pmReadMessageImpl = new PMReadMessageImpl();

        pmReadMessageImpl.setReadMessageId(readMessageId);
        pmReadMessageImpl.setMessageId(messageId);

        if (readDate == Long.MIN_VALUE) {
            pmReadMessageImpl.setReadDate(null);
        } else {
            pmReadMessageImpl.setReadDate(new Date(readDate));
        }

        pmReadMessageImpl.resetOriginalValues();

        return pmReadMessageImpl;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        readMessageId = objectInput.readLong();
        messageId = objectInput.readLong();
        readDate = objectInput.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput)
        throws IOException {
        objectOutput.writeLong(readMessageId);
        objectOutput.writeLong(messageId);
        objectOutput.writeLong(readDate);
    }
}
